﻿Public Class CameraCarrier
    Inherits ModelWorldObject

    Public Property ForwardDirection As Single
    Public Property Velocity As Single = 0.75F
    Public Property TurnSpeed As Single = 0.025F


    Sub New(game As Game, world As VirtualWorld, position As Vector3, rotation As Vector3, modelName As String)
        MyBase.New(game, world, position, rotation, New Vector3(0.1), modelName)
        Me.ForwardDirection = 0.0F
        Me.UseBoundingBoxForCollisions = False
    End Sub

    Protected Overrides Sub OnBoundingSphereUpdated()
        MyBase.OnBoundingSphereUpdated()
        Me._BoundingSphere.Center = Me._BoundingSphere.Center + New Vector3(0, 1, 0)
        Me._BoundingSphere.Radius = 2.0F
    End Sub

    Protected Overrides Sub OnBoundingBoxUpdated()
        MyBase.OnBoundingBoxUpdated()
        Me._BoundingBox = New BoundingBox(Me._BoundingBox.Min, Me._BoundingBox.Max + New Vector3(0, 5, 0))
    End Sub

    Public Overrides Sub Draw(gameTime As Microsoft.Xna.Framework.GameTime)
    Dim transforms(Me.Model.Bones.Count) As Matrix
        Me.Model.CopyAbsoluteBoneTransformsTo(transforms)
        Dim worldMatrix As Matrix = Matrix.Identity
        Dim rotationYMatrix As Matrix = Matrix.CreateRotationY(Me.ForwardDirection)
        Dim scaleMatrix As Matrix = Matrix.CreateScale(Me.Scale)
        Dim translateMatrix As Matrix = Matrix.CreateTranslation(Me.Position)
        worldMatrix = scaleMatrix * rotationYMatrix * translateMatrix
        Me.BeginDraw(Me.World.ViewMatrix, Me.World.ProjectionMatrix, Me.GraphicsDevice, Me.World.Effect)
        For Each mesh As ModelMesh In Model.Meshes
            For Each e As BasicEffect In mesh.Effects
                e.World = worldMatrix * transforms(mesh.ParentBone.Index)
                e.View = Me.World.Camera.ViewMatrix
                e.Projection = Me.World.Camera.ProjectionMatrix
                e.EnableDefaultLighting()
                e.PreferPerPixelLighting = True
            Next
            mesh.Draw()
        Next
        Me.EndDraw(Me.World.ViewMatrix, Me.World.ProjectionMatrix, Me.GraphicsDevice, Me.World.Effect)
    End Sub

    Public Overrides Sub Update(gameTime As Microsoft.Xna.Framework.GameTime)
        ''''DISABLE ALL USER INTERACTION WITH THE GAME
        'If Keyboard.GetState.IsKeyDown(Keys.Space) Then
        '    Me.Shoot(gameTime)
        'End If
        'Dim futurePosition As Vector3 = Me.Position
        'Dim turnAmount As Single = 0
        'If Keyboard.GetState.IsKeyDown(Keys.Left) Then
        '    turnAmount = 1
        'ElseIf Keyboard.GetState.IsKeyDown(Keys.Right) Then
        '    turnAmount = -1
        'ElseIf GamePad.GetState(0).ThumbSticks.Left.X <> 0 Then
        '    turnAmount = -GamePad.GetState(0).ThumbSticks.Left.X
        'End If
        'Me.ForwardDirection += turnAmount * Me.TurnSpeed
        'Dim orientationMatrix As Matrix = Matrix.CreateRotationY(ForwardDirection)
        'Dim movement As Vector3 = Vector3.Zero
        'If Keyboard.GetState.IsKeyDown(Keys.Up) Then
        '    movement.Z = 1
        'ElseIf Keyboard.GetState.IsKeyDown(Keys.Down) Then
        '    movement.Z = -1
        'ElseIf GamePad.GetState(0).ThumbSticks.Left.Y <> 0 Then
        '    movement.Z = GamePad.GetState(0).ThumbSticks.Left.Y
        'End If
        'Dim speed As Vector3 = Vector3.Transform(movement, orientationMatrix)
        'speed *= Me.Velocity
        'futurePosition = Position + speed
        'Dim ignorableObjects As New List(Of WorldObject)
        'ignorableObjects.Add(Me.World.FloorBlock)
        'If Me.ValidateMovement(futurePosition, Me.BoundingSphere, ignorableObjects) Then
        '    Me.Position = futurePosition
        'End If
    End Sub

    Public LastBulletTime As Double
    Public ShootRefractoryPeriod As Integer = 200
    Public BulletPower As Integer = 100

    Public Sub Shoot(GameTime As GameTime)
        Dim currentTime As Double = GameTime.TotalGameTime.TotalMilliseconds
        If (currentTime - Me.LastBulletTime > Me.ShootRefractoryPeriod) Or Me.LastBulletTime = 0 Then
            Me.Shoot()
            Me.LastBulletTime = currentTime
        End If
    End Sub

    Public Sub Shoot()
        Dim bulletPosition As Vector3 = New Vector3(Me.Position.X, 6, Me.Position.Z)
        Bullet.FireBullet(Me.Game, Me.World, bulletPosition, Me.ForwardDirection, Me, Me.BulletPower)
    End Sub

End Class

